/*
 * Decompiled with CFR 0.152.
 */
package io.github.kosmx.emotes.common;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;

public class SerializableConfig {
    public final ArrayList<ConfigEntry<?>> basics = new ArrayList();
    public final ArrayList<ConfigEntry<?>> expert = new ArrayList();
    public static final int staticConfigVersion = 4;
    public int configVersion;
    public final BooleanConfigEntry showDebug = new BooleanConfigEntry("debug", "showDebug", (Boolean)true, false, (List<ConfigEntry<?>>)this.expert);
    public final BooleanConfigEntry validateEmote = new BooleanConfigEntry("validate", (Boolean)false, true, (List<ConfigEntry<?>>)this.expert);
    public final FloatConfigEntry<Float> validThreshold = new FloatConfigEntry("validationThreshold", "validThreshold", Float.valueOf(8.0f), true, this.expert, "options.generic_value", 0.2f, 16.0f, 0.0f);
    public final ConfigEntry<Boolean> loadBuiltinEmotes = new BooleanConfigEntry("loadbuiltin", "loadBuiltin", (Boolean)true, true, (List<ConfigEntry<?>>)this.basics);
    public final BooleanConfigEntry loadEmotesServerSide = new BooleanConfigEntry("emotesFolderOnLogicalServer", false, true, this.expert, true);
    public final ConfigEntry<Boolean> enableQuark = new BooleanConfigEntry("quark", "enablequark", (Boolean)false, true, (List<ConfigEntry<?>>)this.basics);
    public final StringConfigEntry emotesDir = new StringConfigEntry("emotesDirectory", "emotes", false, this.expert, true);

    public void iterate(Consumer<ConfigEntry<?>> consumer) {
        this.basics.forEach(consumer);
        this.expert.forEach(consumer);
    }

    public void iterateGeneral(Consumer<ConfigEntry<?>> consumer) {
        this.basics.forEach(consumer);
    }

    public void iterateExpert(Consumer<ConfigEntry<?>> consumer) {
        this.expert.forEach(consumer);
    }

    public SerializableConfig() {
        this.loadEmotesServerSide.set(true);
    }

    public static class BooleanConfigEntry
    extends ConfigEntry<Boolean> {
        public BooleanConfigEntry(String name, String oldconfig, Boolean defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, oldconfig, defVal, hasTooltip, collection, hidden);
        }

        public BooleanConfigEntry(String name, String oldconfig, Boolean defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            super(name, oldconfig, defVal, hasTooltip, collection);
        }

        public BooleanConfigEntry(String name, Boolean defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, null, defVal, hasTooltip, collection, hidden);
        }

        public BooleanConfigEntry(String name, Boolean defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            super(name, defVal, hasTooltip, collection);
        }

        public BooleanConfigEntry(String name, Boolean defVal, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, defVal, collection, hidden);
        }
    }

    public static class FloatConfigEntry<T extends Number>
    extends ConfigEntry<Float> {
        private final String formatKey;
        public final float min;
        public final float max;
        public final float step;

        public FloatConfigEntry(String name, String oldconfig, Float defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, String formatKey, float min, float max, float step) {
            super(name, oldconfig, defVal, hasTooltip, collection);
            this.formatKey = formatKey;
            this.min = min;
            this.max = max;
            this.step = step;
        }

        public FloatConfigEntry(String name, Float defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, String formatKey, float min, float step, float max) {
            this(name, null, defVal, hasTooltip, collection, formatKey, min, max, step);
        }

        public String getFormatKey() {
            return this.formatKey;
        }

        public double getConfigVal() {
            return Math.sqrt(((Float)this.get()).floatValue());
        }

        public void setConfigVal(double newVal) {
            this.set(Float.valueOf((float)Math.pow(newVal, 2.0)));
        }

        public T getTextVal() {
            return (T)((Number)this.get());
        }
    }

    public static abstract class ConfigEntry<T> {
        final String name;
        final String oldConfig;
        T value;
        final T defaultValue;
        public final boolean hasTooltip;
        final boolean isHidden;

        public ConfigEntry(String name, String oldconfig, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            this.name = name;
            this.oldConfig = oldconfig;
            this.hasTooltip = hasTooltip;
            this.defaultValue = defVal;
            this.value = defVal;
            collection.add(this);
            this.isHidden = hidden;
        }

        public ConfigEntry(String name, String oldconfig, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            this(name, oldconfig, defVal, hasTooltip, collection, false);
        }

        public ConfigEntry(String name, T defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            this(name, null, defVal, hasTooltip, collection);
        }

        public ConfigEntry(String name, T defVal, List<ConfigEntry<?>> collection, boolean hidden) {
            this(name, null, defVal, false, collection, hidden);
        }

        public T get() {
            return this.value;
        }

        public void set(T newValue) {
            this.value = newValue;
        }

        public String getName() {
            return this.name;
        }

        public String getOldConfigName() {
            return this.oldConfig;
        }

        public void resetToDefault() {
            this.value = this.defaultValue;
        }

        public boolean showEntry() {
            return !this.isHidden;
        }
    }

    public static class StringConfigEntry
    extends ConfigEntry<String> {
        public StringConfigEntry(String name, String defVal, boolean hasTooltip, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, null, defVal, hasTooltip, collection, hidden);
        }

        public StringConfigEntry(String name, String defVal, boolean hasTooltip, List<ConfigEntry<?>> collection) {
            super(name, defVal, hasTooltip, collection);
        }

        public StringConfigEntry(String name, String defVal, List<ConfigEntry<?>> collection, boolean hidden) {
            super(name, defVal, collection, hidden);
        }
    }
}

